/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.websm.updates;

import com.ibm.hsc.common.exceptions.PIHscClientException;
import com.ibm.hsc.websm.updates.PIFlashLID;
import com.ibm.hsc.websm.updates.PIUpdateDefines;
import com.ibm.hsc.websm.updates.PIUpdateErrorIds;
import com.ibm.hsc.websm.updates.PIUpdateException;
import com.ibm.hsc.websm.updates.TargettedFsp;
import com.ibm.hwmca.base.updates.UpdateUtilities;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;

public class MasterLID
extends PIFlashLID
implements PIUpdateErrorIds,
PIUpdateDefines {
    private static final String TRACE_MASKT = "XUPDMSTT";
    private static final String TRACE_MASKF = "XUPDMSTF";
    private static final String TRACE_MASKD = "XUPDMSTD";
    private static final int MASTER_LID_RECORD_SIZE = 88;
    private String dataArea;
    private static Integer headerLock = new Integer(0);
    private List lids;
    private static Integer lidLock = new Integer(0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MasterLID(TargettedFsp targettedFsp, boolean bl) throws HException {
        Object object;
        Object object2;
        Trace.trace((String)TRACE_MASKT, (Object)"-> MasterLID()");
        Vector<UnsignedInt16> vector = new Vector<UnsignedInt16>();
        vector.add(new UnsignedInt16(2));
        Vector<UnsignedInt8> vector2 = new Vector<UnsignedInt8>();
        if (bl) {
            vector2.add(new UnsignedInt8(1));
        } else {
            vector2.add(new UnsignedInt8(0));
        }
        try {
            this.dataArea = BaseFileControl.getFilePath((String)"iqzmsupd.dat");
        }
        catch (HException hException) {
            Trace.trace((String)TRACE_MASKF, (Object)("Failed to set up data area " + (Object)((Object)hException)));
            PIUpdateException pIUpdateException = new PIUpdateException(-2005, hException);
            throw pIUpdateException;
        }
        Vector<String> vector3 = new Vector<String>();
        String string = this.dataArea + "master.lid.fipsheader";
        vector3.add(string);
        Vector<Object> vector4 = new Vector<Object>();
        vector4.add(new UnsignedInt32(0L));
        UnsignedInt32 unsignedInt32 = new UnsignedInt32(108L);
        Vector<UnsignedInt32> vector5 = new Vector<UnsignedInt32>();
        vector5.add(unsignedInt32);
        Integer n = headerLock;
        synchronized (n) {
            File file = new File(string);
            if (file.exists()) {
                Trace.trace((String)TRACE_MASKD, (Object)"Deleting the master LID FIPS header.");
                file.delete();
            }
            try {
                Trace.trace((String)TRACE_MASKD, (Object)("Calling readSpecialLID lidNumber=" + vector.firstElement() + " side=" + vector2));
                targettedFsp.readSpecialLID("master", vector, vector2, vector3, vector4, vector5);
                Trace.trace((String)TRACE_MASKD, (Object)"readSpecialLID completed.");
            }
            catch (PIHscClientException pIHscClientException) {
                Trace.trace((String)TRACE_MASKF, (Object)("Failed pulling master LID FIPS header from flash " + pIHscClientException));
                PIUpdateException pIUpdateException = new PIUpdateException(-2006, pIHscClientException);
                throw pIUpdateException;
            }
            super.initAsFile(file);
        }
        string = this.dataArea + "master.lid";
        vector3.set(0, string);
        n = new UnsignedInt32((long)super.getHeaderLength());
        vector4.set(0, n);
        int n2 = super.getLidLength();
        vector5.set(0, new UnsignedInt32((long)n2));
        byte[] byArray = new byte[n2];
        Object object3 = lidLock;
        synchronized (object3) {
            object2 = new File(string);
            if (((File)object2).exists()) {
                Trace.trace((String)TRACE_MASKD, (Object)"Deleting the master LID file.");
                ((File)object2).delete();
            }
            try {
                Trace.trace((String)TRACE_MASKD, (Object)("Calling readSpecialLID lidNumber=" + vector.firstElement() + " side=" + vector2.firstElement() + " offset=" + vector4.firstElement() + " size=" + vector5.firstElement()));
                targettedFsp.readSpecialLID("master", vector, vector2, vector3, vector4, vector5);
                Trace.trace((String)TRACE_MASKD, (Object)"readSpecialLID completed.");
            }
            catch (PIHscClientException pIHscClientException) {
                Trace.trace((String)TRACE_MASKF, (Object)("Failed pulling master LID from flash " + pIHscClientException));
                PIUpdateException pIUpdateException = new PIUpdateException(-2008, pIHscClientException);
                throw pIUpdateException;
            }
            try {
                FileInputStream fileInputStream = new FileInputStream(string);
                object = new BufferedInputStream(fileInputStream, n2);
                UpdateUtilities.readFully((BufferedInputStream)object, (byte[])byArray);
                Trace.trace((String)TRACE_MASKF, (Object)("Read MasterLID [" + byArray + "]"));
            }
            catch (IOException iOException) {
                Trace.trace((String)TRACE_MASKF, (Object)("I/O exception reading Master LID " + iOException));
                PIUpdateException pIUpdateException = new PIUpdateException(-2007, iOException);
                throw pIUpdateException;
            }
        }
        object3 = new byte[108];
        System.arraycopy(byArray, 0, object3, 0, 108);
        object2 = new PIFlashLID((byte[])object3);
        int n3 = ((PIFlashLID)object2).getHeaderLength();
        object = new byte[n3];
        this.lids = new ArrayList();
        for (int i = 0; i < n2; i += n3) {
            Trace.trace((String)TRACE_MASKD, (Object)("currentOffset=" + i));
            System.arraycopy(byArray, i, object, 0, n3);
            PIFlashLID pIFlashLID = new PIFlashLID((byte[])object);
            this.lids.add(pIFlashLID);
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- MasterLID()");
    }

    public List getLIDs() {
        Trace.trace((String)TRACE_MASKT, (Object)"-> getLIDs()");
        Trace.trace((String)TRACE_MASKT, (Object)"<- getLIDs");
        return this.lids;
    }
}

